/*
 * Speed_measurement.c
 *
 * Created: 9/15/2012 8:50:23 PM
 *  Author: Thomas L
 */ 


#define F_CPU 14.7456E6  

#include <avr/io.h>
#include <util/delay.h>
#include <avr/interrupt.h>


/************************************************************************/
/*							declare global variables                    */
/************************************************************************/
	unsigned int result = 0;
	int interruptcount = 0;
	long int time = 0;
	long int resetcount = 0;
	
	
	
	


int main(void)
{
	
	DDRD = 0x00;							//portd input for external interrupts
	DDRC = 0xDF;							//portc output for 7 segment multiplexing and 1 input for distance display
	DDRB = 0xFF;							//portb output fot 7 segment data in bcd
	PORTD |= 0xFF;							//enable portd pull up resistors 
											//(int0 and int1 require external pull up resistors or 1 interrupt will be triggered at reset)
	
	EICRA |= (1<<ISC11)|(1<<ISC01);			//configure external interrupts
	EIMSK |= (1<<INT1)|(1<<INT0);			//
	TCCR1B |= (1<<CS12);					//set prescaling for timer1 256
	
	
	
	
	
/************************************************************************/
/*			declare variables for calculation and display               */
/************************************************************************/
			
			unsigned int ones = 0;
			unsigned int tens = 0;
			unsigned int hundreds = 0;
			unsigned int x = 0;
			double ticsfoot = 0;
			double fps = 0;
			double fph = 0;
			double mph = 0;
			double kph = 0;
			double mps = 0;
			int distance = 0;
	
			
	sei();								//enable global interrupts
			
	
	
					                                                                     
	while(1)
	{
		
		
		
/************************************************************************/
/*				get sensor distance in feet from pind 0,1,4,5           */
/************************************************************************/

		int distanceinput = (~PIND & 0x33);
		int hibits = (distanceinput >> 2);						//getting pind bits 0,1 and 4,5 together to be
		int lobits = (distanceinput & 0x03);					//distance value in BCD.  bits 2,3 are the 
		distance = (hibits + lobits);							//ext interrupt pins already in use.
		
		if (distance == 0) distance = 16;
		
		
		
/************************************************************************/
/*				    'ready' indicator LED                    */
/************************************************************************/		
		
		if (interruptcount == 0)
		{
			PORTC |= (1<<3);
		}
		else
		{
			PORTC &= (0<<3);
		}



/************************************************************************/
/*                 calculations to find speed in 4 units                */
/************************************************************************/



		if (interruptcount == 2)									//only calculate when both interrupts have occurred				
		{
				cli();											    //disable global interrupts
				
				ticsfoot = (time / distance);						//distance is distance between sensors in feet - ticsfoot is counter tics/foot
				fps = (57600 / ticsfoot);							//57600 is counter tics/sec (cpu clk/prescaler)
				fph = (fps * 60 * 60);
				mph = (fph / 5280);
				kph = (mph * 1.609344);
				mps = (fps * 0.3048);
				
				EIMSK |= (1<<INT1)|(1<<INT0);						//
				sei();												//re-enable external interrupts and global interrupts
		}	







/************************************************************************/
/*                        choose output options                         */
/************************************************************************/

			if (!(PIND & (1<<PIND6)) && (PIND & (1<<PIND7)))					//choose feet/sec
			{
				round(fps);
				result = fps;
			}
				else if (PIND & (1<<PIND6) && !(PIND & (1<<PIND7)))				//choose meters/sec
				{
					round(mps);
					result = mps;
				}	
					else if (PIND & (1<<PIND6) && (PIND & (1<<PIND7)))			//choose kilometers/hr
					{
						round(kph);
						result = kph;
					}
						else													//default miles/hr
						{
							round(mph);
							result = mph;
						}	
				

		if (result >= 999) result = 999;
		
		
		
		
		
		
		
/************************************************************************/
/*              delay to stop multiple "2nd interrupt" triggers         */
/*                   without delaying main code execution               */
/************************************************************************/
		
		resetcount++;
		
		if ((resetcount >= 0x00FF) && (interruptcount >= 2))					 //resetcount upper limit determines delay
		{																		 //before reset. 0x00FF approx. 3 sec
			interruptcount = 0;
			resetcount = 0;
		}
		
		
		
		
		
		
		
		
/************************************************************************/
/* 			 display int result on 3 digit seven segment display        */
/*  delay gives seven segment decoder time to decode and display digits */                                                                    
/************************************************************************/

	if (!(PINC & (1<<PINC5)))							//to display distance setting on display
		{												//only while button is pressed
		result = distance;	
		}
	else
		

			
		hundreds = (result / 100);						//get 100's place digit
		x = (result % 100);
		PORTB = (0x00|hundreds);
		PORTC |= (1<<2);								// write digit 
		_delay_ms(1);
		PORTC &= (0<<2);
	
		tens = (x / 10);								// get 10's place digit
		x = x % 10;
		PORTB = (0x00|tens);
		PORTC |= (1<<1);								// write digit
		_delay_ms(1);
		PORTC &= (0<<1);

		ones = x;										// get 1's place digit
		PORTB = (0x00|ones);
		PORTC |= (1<<0);								// write digit
		_delay_ms(1);
		PORTC &= (0<<0);					
				
	
	}    
}






/************************************************************************/
/*                        sensor 1 interrupt                            */
/************************************************************************/
ISR(INT0_vect)
{
	if (interruptcount == 0)
	{
		TCNT1 = 0x0000;									 //reset counter to 0
		interruptcount++;								 //increment interrupt count
		EIMSK &= (1<<INT1)|(0<<INT0);					 //disable INT0
		
	}
	else if (interruptcount == 1)
	{
		time = TCNT1;									 //capture counter value
		interruptcount++;								 //increment interrupt count
		
	}
	else resetcount = 0;
	
}

/************************************************************************/
/*                        sensor 2 interrupt                            */
/************************************************************************/
ISR(INT1_vect)
{
	if (interruptcount == 0)
	{	
		TCNT1 = 0x0000;									//reset counter to 0
		interruptcount++;								//increment interrupt count
		EIMSK &= (0<<INT1)|(1<<INT0);					//disable INT1
				
	}
	else if (interruptcount == 1)
	{
		time = TCNT1;									//capture counter value
		interruptcount++;								//increment interrupt count
		
	}
	else resetcount = 0;
}




	




